# NOTE - need an option to "tosvd" that will list the output formats
#        available along with their descriptions
# NOTE - the radiobutton that "matches" the given floppy drive should
#        be initially checked off.  This should be the first in the
#        list as reported by the osfiles routines.

########################################################################
# floppyUploadDialogCreate() -	Create the dialog that is used when
#                               uploading
########################################################################
proc floppyUploadDialogCreate {} {
    iwidgets::dialogshell .upload -title "Uploading Floppy from SVD" -master .

    .upload add stop -text "STOP" -command { floppyUploadStop }

#    .upload configure -modality application
    .upload configure

    set upload [.upload childsite]

    label $upload.total -relief flat -text "more..."
    gaugeCreate $upload.totalgauge white 180 20

    pack $upload.total -anchor n -side top -expand yes -fill x
    pack $upload.totalgauge -side top -expand yes
}

########################################################################
# floppyUploadStop() -	Called to cause termination of floppy loading...
########################################################################
proc floppyUploadStop {} {
    global floppyUploadStopped

    .upload buttonconfigure stop -state disabled
    set floppyUploadStopped 1
}

################################################################################
# floppyUpload() - called to cause an upload of a floppy image from the SVD.
#                  The floppy to upload is given as the argument.
################################################################################
proc floppyUpload {num} {
    global fudformat
    global OSListFile
    global tosvdFormats

    global floppyLoaded
    global floppyType
    global floppyFiles
    global floppyImage
    global floppyEnabled
    global floppyProtected
    global floppyFilesOS
    global floppyMemoryUsed

    global floppyUploadFile
    global floppyUploadStopped

    set floppyUploadStopped 0

    if {$floppyLoaded($num)} {
	set answer [tk_messageBox -default yes -icon warning -title "WARNING"  \
		                 -type yesno \
				 -message "Floppy $num already has an image.\nEject it and upload?" ]
	if { $answer != "yes" } {
	    return 0
	} else {
	    floppyEject $num
	}
    }

    #
    # get the gauge to appear in the middle of the main window
    #
    set newx [expr [winfo x .] + ([winfo width .]/2) - ([winfo width .upload] / 2)]
    set newy [expr [winfo y .] + ([winfo height .]/2) - ([winfo height .upload] / 2)]
    wm geometry .upload [format "+%d+%d" $newx $newy]

    gaugeValue [.upload childsite].totalgauge 0 0

    .upload buttonconfigure stop -state normal

    .upload activate

    #
    # first create a temporary file where the uploaded image will
    # be stored.  The channel is passed around, but close before return
    # NOTE - this file needs to be deleted when an uploaded floppy is
    # ejected - should be a warning too...which indicates that a "saved"
    # indicator should be kept.

    [.upload childsite].total configure -text "Creating Temporary File..."
    update

    set tempfilename [tempfile "svd"]
    if { [catch {open $tempfilename w} channel] } {
	tk_messageBox -default ok -icon error -title "ERROR"  \
		      -type ok -message "Can't open temporary file for upload."
	.upload deactivate
    }
    fconfigure $channel -encoding binary -translation binary

# Have to be careful here.  Even if we don't think we are "connected"
# we need to try to upload the image.  The problem is that if we try
# to "connect" in the traditional sense, the whole machine will be reset.

    [.upload childsite].total configure -text "Contacting SVD..."
    update

    # do a "check" style operation to see if the SVD is out there
    # this could cause a hiccup in floppy operation, but won't mess things up

    if { ! [svdCheck 0] } {
	.upload deactivate
	return
    }

    # now put the breaks on the floppy activity so upload won't mess things up
    
    [.upload childsite].total configure -text "Stopping SVD Activity..."
    update
    svdStop
    after 1000

    [.upload childsite].total configure -text "Uploading..."
    update

    set memused [svdUploadFloppy $num $channel]
    close $channel
    if { $memused != 0 } {
	set floppyType($num) "upload"
	set floppyUploadFile($num) $tempfilename
	set floppyLoaded($num) 1
	set floppyMemoryUsed($num) $memused
	floppyMemoryIndicator $num
	floppyGuiEnable $num
    } else {
	file delete -force $tempfilename
    }

    [.upload childsite].total configure -text "Restarting SVD Activity..."
    update
    svdStart
    after 1000

    .upload deactivate

    return
}
